% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_helpers.R
\name{format_results}
\alias{format_results}
\title{Format Results for Reporting}
\usage{
format_results(
  results,
  digits = 2,
  ci_format = c("parens", "brackets", "dash"),
  pval_digits = 3,
  include_se = FALSE
)
}
\arguments{
\item{results}{A tibble from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} or \code{\link[=combine_results]{combine_results()}}.}

\item{digits}{Integer specifying the number of decimal places for estimates.
Default is 2.}

\item{ci_format}{Character string specifying CI format. Options are:
"parens" for "(LCI, UCI)", "brackets" for "\[LCI, UCI\]", or "dash" for
"LCI - UCI". Default is "parens".}

\item{pval_digits}{Integer specifying decimal places for p-values. Default is 3.}

\item{include_se}{Logical indicating whether to include standard error column.
Default is FALSE.}
}
\value{
A tibble with formatted columns suitable for reporting.
}
\description{
Formats a tidy results tibble for publication-ready reporting, with options
for rounding, confidence interval formatting, and column selection.
}
\examples{
\donttest{
library(rbmi)

# Assuming you have a tidy result
# tidy_result <- tidy_pool_obj(pool_obj)
# formatted <- format_results(tidy_result, digits = 3, ci_format = "brackets")
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} to create tidy results
\item \code{\link[=combine_results]{combine_results()}} to combine multiple analyses
}
}
