% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectRasterDWD.R
\name{projectRasterDWD}
\alias{projectRasterDWD}
\title{project DWD raster data}
\usage{
projectRasterDWD(
  r,
  proj = "radolan",
  extent = "radolan",
  adjust05 = FALSE,
  targetproj = "ll",
  threads = TRUE,
  quiet = rdwdquiet()
)
}
\arguments{
\item{r}{terra raster object}

\item{proj}{Current projection to be given to \code{r}. Can be\cr
- a \code{\link[terra:crs]{terra::crs()}} input,\cr
- NULL to not set proj+extent (but still consider \code{targetproj}),\cr
- or a special charstring for internal defaults, namely:
"radolan" (readDWD.binary + .asc + .radar), "seasonal" (.raster) or "nc"  (.nc).\cr
DEFAULT: "radolan"}

\item{extent}{Current \code{\link[terra:ext]{terra::ext()}} extent to be given to \code{r}.
Ignored if \code{proj=NULL}. Can be NULL to be ignored, an extent object,
a vector with 4 numbers, or "radolan" / "rw" / "seasonal" / "nc" with internal defaults.
DEFAULT: "radolan"}

\item{adjust05}{Logical: Adjust extent by 0.5m to match edges? DEFAULT: FALSE}

\item{targetproj}{\code{r} is reprojected to this \code{\link[terra:crs]{terra::crs()}}.
Use NULL to not reproject (i.e. only set proj and extent).
DEFAULT: "ll" with internal default for lat-lon.}

\item{threads}{Use multiple CPU threads for \code{\link[terra:project]{terra::project()}}?
DEFAULT: TRUE (opposite from terra::project)}

\item{quiet}{Logical: suppress progress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
terra raster object with projection and extent, invisible
}
\description{
Set projection and extent for DWD raster data. Optionally (and
per default) also reprojects to latlon data.\cr\cr
\strong{WARNING:} reprojection to latlon changes values slightly. For the
tested RX product, this change is significant, see:
\url{https://github.com/brry/rdwd/blob/master/misc/ExampleTests/Radartests.pdf}\cr
In terra::plot, \strong{use range=zlim with the original range} if needed.
}
\details{
The internal defaults are extracted from the Kompositformatbeschreibung at
\url{https://www.dwd.de/DE/leistungen/radolan/radolan.html}, as provided
2019-04 by Antonia Hengst.\cr The nc extent was obtained by projecting
Germanys bbox to EPSG 3034 (specified in the DWD documentation). Using that
as a starting point, I then refined the extent to a visual match, see
\href{https://github.com/brry/rdwd/blob/master/misc/developmentNotes.R}{developmentNotes.R}\cr\cr
}
\examples{
# To be used after readDWD.binary etc
}
\seealso{
\code{\link[=plotRadar]{plotRadar()}}\cr
\verb{terra::}\code{\link[terra:crs]{crs}} / \code{\link[terra:ext]{ext}} / \code{\link[terra:project]{project}}\cr
\code{readDWD.}\code{\link[=readDWD.binary]{binary}} / \code{\link[=readDWD.raster]{raster}} /
\code{\link[=readDWD.asc]{asc}} / \code{\link[=readDWD.radar]{radar}} / \code{\link[=readDWD.nc]{nc}}\cr
\href{https://brry.github.io/rdwd/raster-data.html}{website raster chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2019, June 2023
}
\keyword{aplot}
