% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{getVerificationArgs}
\alias{getVerificationArgs}
\title{Get the correct values for RI, RIperc, Lambda, and Shift for the verification}
\usage{
getVerificationArgs(
  RIdata,
  RIcand,
  RIperc,
  pointEst = c("fullDataEst", "medianBS"),
  verbose = TRUE
)
}
\arguments{
\item{RIdata}{specifying the RI of the local population: (1) (object) of class RWDRI or (2) (numeric) representation of reference limits}

\item{RIcand}{specifying the RI that needs to be verified: (1) (object) of class RWDRI or (2) (numeric) representation of reference limits}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}

\item{pointEst}{(character) specifying the point estimate determination: (1) using the full dataset ("fullDataEst"),
(2) calculating the median model from the bootstrap samples ("medianBS"), (2) works only if NBootstrap > 0}

\item{verbose}{(logical) specifying if additional warning messages are printed}
}
\value{
(list) containing a list with the "RI", "Lambda", "Shift" parameter for  RIdata and RIcand each
}
\description{
This function adapts the list of test arguments based on the margin type and additional test parameters
}
\author{
Matthias Beck \email{matthias.beck.mb1@roche.com}
}
