% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_hh.R
\name{scan_hh}
\alias{scan_hh}
\title{Compute iHH, iES and inES over a whole chromosome}
\usage{
scan_hh(
  haplohh,
  limhaplo = 2,
  limhomohaplo = 2,
  limehh = 0.05,
  limehhs = 0.05,
  phased = TRUE,
  polarized = TRUE,
  scalegap = NA,
  maxgap = NA,
  discard_integration_at_border = TRUE,
  lower_ehh_y_bound = limehh,
  lower_ehhs_y_bound = limehhs,
  interpolate = TRUE,
  threads = 1
)
}
\arguments{
\item{haplohh}{an object of class \code{haplohh} (see \code{\link{data2haplohh}})}

\item{limhaplo}{if there are less than \code{limhaplo} chromosomes that can be used for
the calculation of EHH(S), the calculation is stopped. The option is intended for the case of missing data,
which leads to the successive exclusion of haplotypes: the further away from the focal marker
the less haplotypes contribute to EHH(S).}

\item{limhomohaplo}{if there are less than \code{limhomohaplo} homozygous chromosomes, the
calculation is stopped. This option is intended for unphased data and should be invoked only
if relatively low frequency variants are not filtered subsequently (see main vignette and Klassmann et al. 2020).}

\item{limehh}{limit at which EHH stops to be evaluated.}

\item{limehhs}{limit at which EHHS stops to be evaluated.}

\item{phased}{logical. If \code{TRUE} (default) chromosomes are expected to be phased. If \code{FALSE}, the haplotype data is assumed to
consist of pairwise ordered chromosomes belonging to diploid individuals.
EHH(S) is then estimated over individuals which are homozygous at the focal marker.}

\item{polarized}{logical. \code{TRUE} by default. If \code{FALSE}, use major and minor allele instead of ancestral and derived. If there
are more than two alleles then the minor allele refers to the second-most frequent allele.}

\item{scalegap}{scale or cap gaps larger than the specified size to the specified size (default=\code{NA}, i.e. no scaling).}

\item{maxgap}{maximum allowed gap in bp between two markers. If exceeded, further calculation of EHH(S) is stopped at the gap
(default=\code{NA}, i.e no limitation).}

\item{discard_integration_at_border}{logical. If \code{TRUE} (default) and computation reaches first or last marker or a gap larger than \code{maxgap},
iHH, iES and inES are set to \code{NA}.}

\item{lower_ehh_y_bound}{lower y boundary of the area to be integrated over (default: \code{limehh}). Can be set
to zero for compatibility with the program hapbin.}

\item{lower_ehhs_y_bound}{lower y boundary of the area to be integrated (default: \code{limehhs}). Can be set
to zero for compatibility with the program hapbin.}

\item{interpolate}{logical. If \code{TRUE} (default), integration
is performed over a continuous EHH(S) curve (values are interpolated linearly between consecutive markers),
otherwise the EHH(S) curve decreases stepwise at markers.}

\item{threads}{number of threads to parallelize computation}
}
\value{
The returned value is a dataframe with markers in rows and the following columns
\enumerate{
\item chromosome name
\item position in the chromosome
\item sample frequency of the ancestral / major allele
\item sample frequency of the second-most frequent remaining allele
\item number of evaluated haplotypes at the focal marker for the ancestral / major allele
\item number of evaluated haplotypes at the focal marker for the second-most frequent remaining allele
\item iHH of the ancestral / major allele
\item iHH of the second-most frequent remaining allele
\item iES (used by Sabeti et al 2007)
\item inES (used by Tang et al 2007)}
Note that in case of unphased data the evaluation is restricted to
haplotypes of homozygous individuals which reduces the power
to detect selection, particularly for iHS (for appropriate parameter setting
see the main vignette and Klassmann et al (2020)).
}
\description{
Compute integrated EHH (iHH), integrated EHHS (iES) and integrated normalized EHHS (inES)
for all markers of a chromosome (or linkage group).
}
\details{
Integrated EHH (iHH), integrated EHHS (iES) and integrated normalized EHHS (inES)
are computed for all markers of the chromosome (or linkage group). This function is several
times faster as a procedure calling in turn \code{calc_ehh} and \code{calc_ehhs}
for all markers. To perform a whole genome-scan this function needs
to be called for each chromosome and results concatenated.

Note that setting \code{limehh} or \code{limehhs} to zero is likely to reduce power,
since even under neutrality a tiny fraction (<<0.05) of extremely long shared haplotypes is expected
which, if fully accounted for, would obfuscate the signal at selected sites.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
scan <- scan_hh(haplohh_cgu_bta12)
}
\references{
Gautier, M. and Naves, M. (2011). Footprints of selection in the ancestral admixture of a New World Creole cattle breed. \emph{Molecular Ecology}, \strong{20}, 3128-3143.

Klassmann, A. and Gautier, M. (2022). Detecting selection using extended haplotype homozygosity (EHH)-based statistics in unphased or unpolarized data. \emph{PLoS One}. \strong{17}(1):e0262024
\doi{10.1371/journal.pone.0262024}

Sabeti, P.C. et al. (2002). Detecting recent positive selection in the human genome from haplotype structure. \emph{Nature}, \strong{419}, 832-837.

Sabeti, P.C. et al. (2007). Genome-wide detection and characterization of positive selection in human populations. \emph{Nature}, \strong{449}, 913-918.

Tang, K. and Thornton, K.R. and Stoneking, M. (2007). A New Approach for Using Genome Scans to Detect Recent Positive Selection in the Human Genome. \emph{Plos Biology}, \strong{7}, e171.

Voight, B.F. and Kudaravalli, S. and Wen, X. and Pritchard, J.K. (2006). A map of recent positive selection in the human genome. \emph{Plos Biology}, \strong{4}, e72.
}
\seealso{
\code{\link{data2haplohh}}, \code{\link{calc_ehh}}, \code{\link{calc_ehhs}}
\code{\link{ihh2ihs}},\code{\link{ines2rsb}}, \code{\link{ies2xpehh}}
}
