% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedMethods.R
\name{.wrap}
\alias{.wrap}
\alias{.wrap.list}
\alias{.wrap.environment}
\alias{.wrap.default}
\alias{.unwrap.default}
\alias{.unwrap}
\alias{.unwrap.environment}
\alias{.unwrap.list}
\alias{.unwrap.PackedSpatExtent2}
\alias{.unwrap.PackedSpatVector2}
\alias{.unwrap.data.table}
\alias{.unwrap.PackedSpatVector}
\title{Deal with class for saving to and loading from Cache or Disk}
\usage{
.wrap(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  cacheId = NULL,
  ...
)

\method{.wrap}{list}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  cacheId = NULL,
  ...
)

\method{.wrap}{environment}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  cacheId = NULL,
  ...
)

\method{.wrap}{default}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  preDigest,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  outputObjects = NULL,
  cacheId = NULL,
  ...
)

\method{.unwrap}{default}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

.unwrap(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{environment}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{list}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{PackedSpatExtent2}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{PackedSpatVector2}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{data.table}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)

\method{.unwrap}{PackedSpatVector}(
  obj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  ...
)
}
\arguments{
\item{obj}{Any arbitrary R object.}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{preDigest}{The list of \code{preDigest} that comes from \code{CacheDigest} of an object}

\item{drv}{If using a database backend, \code{drv} must be an object that
inherits from \code{DBIDriver} (e.g., \code{RSQLite::SQLite}).}

\item{conn}{an optional \code{DBIConnection} object, as returned by \code{dbConnect()}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{outputObjects}{Optional character vector indicating which objects to
return. This is only relevant for list, environment (or similar) objects}

\item{cacheId}{Used strictly for messaging. This should be the cacheId of the object being recovered.
Default is \code{NULL}.}

\item{...}{Arguments passed to methods; default does not use anything in \code{...}.}
}
\value{
Returns an object that can be saved to disk e.g., via \code{saveRDS}.
}
\description{
This generic and some methods will do whatever is required to prepare an object for
saving to disk (or RAM) via e.g., \code{saveRDS}. Some objects (e.g., \code{terra}'s \verb{Spat*})
cannot be saved without first wrapping them. Also, file-backed objects are similar.
}
\examples{
# For SpatExtent
if (requireNamespace("terra")) {
  ex <- terra::ext(c(0, 2, 0, 3))
  exWrapped <- .wrap(ex)
  ex1 <- .unwrap(exWrapped)
}

}
