% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isGctFile.R
\name{isGctFile}
\alias{isGctFile}
\title{Test a file is a GCT file or not}
\usage{
isGctFile(file, strict.column.names = FALSE)
}
\arguments{
\item{file}{Character string, a file name}

\item{strict.column.names}{Logical, whether the names of the first two columns must be 'NAME(tab)Description'}
}
\value{
A logical value: \code{TRUE} means \code{file} is of the GCT format.
}
\description{
Test a file is a GCT file or not
}
\details{
A file is a valid GCT file if it meets following three rules:
\enumerate{
  \item The first line of the file is \code{#1.2}
  \item The second line contains number of rows and number of
    columns, separated by a tab.
  \item The rest of file contain a rectangular matrix, with the first
    two columns named \code{NAME} and \code{Description}
    respectively.
}
}
\examples{
myInFile <- system.file("extdata/test.gct", package="ribiosIO")
isGctFile(myInFile)
myInfileLS <- system.file("extdata/test_lessStrict.gct", package="ribiosIO")
isGctFile(myInfileLS)
}
\references{
\url{https://software.broadinstitute.org/cancer/software/genepattern/file-formats-guide}
}
\seealso{
\code{\link{read_gct_matrix}} to read in GCT files
}
