% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMatrix.R
\name{readMatrix}
\alias{readMatrix}
\title{Read in numeric matrix from tab-delimited format written by \code{writeMatrix}}
\usage{
readMatrix(file, row.names = TRUE, as.matrix = TRUE, ...)
}
\arguments{
\item{file}{file to be read in}

\item{row.names}{Logical, whether the first column contains row names (should be consistent with the setting in \code{writeMatrix})}

\item{as.matrix}{Logical, whether the data.frame object should be cast into a matrix}

\item{...}{Other parameters passed to \code{read.table}, for instance \code{stringsAsFactors}. Following parameters are \emph{not} allowed to change: \code{header, sep, quote, dec, check.names, strip.wrhite, comment.char}.}
}
\value{
Matrix when \code{as.matrix} is set to \code{TRUE} and otherwise data.frame
}
\description{
\code{readMatrix} reads a matrix written by \code{writeMatrix} into a R session
}
\details{
Default behaviour of \code{read.table} is adapted to the convention used in \code{writeMatrix}
}
\examples{
test.mat <- matrix(rnorm(1000), nrow=10, dimnames=list(LETTERS[1:10], 1:100))
tmpfile <- tempfile()
writeMatrix(test.mat, tmpfile)
readin.mat <- readMatrix(tmpfile)
if(require(ribiosUtils)) identicalMatrix(test.mat, readin.mat)
}
