% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gmt.R
\name{read_gmt_dataframe}
\alias{read_gmt_dataframe}
\title{Read gene-sets in a GMT file into a data.frame}
\usage{
read_gmt_dataframe(gmt.file, description = FALSE)
}
\arguments{
\item{gmt.file}{Character, name of one gmt-format file}

\item{description}{Logical, whether the result should contain descriptions of
gene-sets as a column.}
}
\value{
A \code{data.frame}. If \code{description} is set to \code{FALSE},
the \code{data.frame} contains two columns: \code{geneset} and \code{gene};
otherwise, it contains three columns: \code{geneset}, \code{description}, and
\code{gene}.
}
\description{
Read gene-sets in a GMT file into a data.frame
}
\examples{

idir <- system.file("extdata", package="ribiosIO")
sample.gmt.file <- file.path(idir, "test.gmt")

testGmtDataframe <- read_gmt_dataframe(sample.gmt.file)

}
