% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascadePlot.R
\name{cascadeOrder}
\alias{cascadeOrder}
\title{Order rows of a matrix in the cascade order}
\usage{
cascadeOrder(matrix, dichotomy = c("maxabs", "mean", "median"))
}
\arguments{
\item{matrix}{A numeric matrix}

\item{dichotomy}{How are the rows divided into two? By maximal abs value
(default), mean value, or the median value of each row.}
}
\value{
An integer vector of row indices in cascade order.
}
\description{
The 'cascade order' is defined by three criteria (1) Rows are divided into
two groups by the condition given by 'dichotomy'. (2) The positive and
negative rows are ordered respectively so that rows reaching its absolute
maximal values in column n are ordered prior to rows reaching reaching its
absolute maximal values in columns n+1, where n can be from 1 to column
number minus one. (3) If two rows reach the maximum value at the same
column, they are ordered by the (decreasing) order of the absolute value in
that column.
}
\details{
See example for illustration of the idea.
}
\examples{

checkBoard <- function(seed=1887) {
  set.seed(seed)
  mat <- matrix(rnorm(76, sd=1), ncol=4)
  delta <- 3
  for(i in seq(1, 16, 2)) {
    rowInd <- i:(i+1)
    colInd <- (i \%/\% 2) \%\% 4 +1
    delta <- ifelse(i>8, -6, 6) * c(0.6, 1)
    mat[rowInd, colInd] <- mat[rowInd, colInd] + delta
  }
  mat[17,1:4] <- rep(-1, 4)
  mat[18,1] <- NA
  mat[18,2] <- mat[18, 2] -6
  mat[19,1:4] <- rep(NA,4)
  rord <- sample(1:nrow(mat), replace=FALSE)
  mat <- mat[rord,]
  rownames(mat) <- sprintf("Row\%d", 1:nrow(mat))
  return(mat)
}
myMat <- checkBoard(1887)
biosHeatmap(myMat, Rowv=FALSE, Colv=FALSE, dendrogram="none",
            zlim=c(-4,4), col="royalbluered",
            main="Original matrix")
## since dist by default does not accept rows full of NAs, we remove them in the example below
biosHeatmap(myMat[apply(myMat, 1, function(x) !all(is.na(x))),],
            Rowv=TRUE, Colv=TRUE, dendrogram="both",
            zlim=c(-4,4), col="royalbluered",
            main="hclust/dist clustering")
## note that cascadeOrder handles invariant rows and rows full of NA values
biosHeatmap(myMat[cascadeOrder(myMat),], Rowv=FALSE, Colv=FALSE, dendrogram="none",
            zlim=c(-4,4), col="royalbluered",
            main="Cascade order")

}
