% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocheCompound.R
\name{rocheCore}
\alias{rocheCore}
\title{Extract core identifiers from Roche compound IDs}
\usage{
rocheCore(str, short = FALSE)
}
\arguments{
\item{str}{Character strings}

\item{short}{Logical, if \code{TRUE}, the short version of Roche identifiers (\code{RO[0-9]{4}}) is returned. Default: \code{FALSE}}
}
\value{
Core identifiers if the element is a Roche compound ID, the original element otherwise
Non-character input will be converted to character strings first.
}
\description{
Extract core identifiers from Roche compound IDs
}
\examples{
rocheCore(c("RO1234567-001", "RO1234567-001-000", "RO1234567", 
    "ROnoise-001", "anyOther-not-affected"))
rocheCore(c("RO1234567-001", "RO1234567-001-000", "RO1234567",
    "ROnoise-001","anyOther-not-affected"), short=TRUE)

}
\seealso{
\code{\link{isRocheCompoundID}}
}
