% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptw_helpers.R
\name{.transform_iptw_to_nnt}
\alias{.transform_iptw_to_nnt}
\title{Transform IPTW Risk Difference Results to Number Needed to Treat}
\usage{
.transform_iptw_to_nnt(iptw_results, nnt_threshold = 0.001)
}
\arguments{
\item{iptw_results}{A tibble with IPTW risk difference results from calc_risk_diff_iptw}

\item{nnt_threshold}{Minimum absolute risk difference for meaningful NNT (default: 0.001)}
}
\value{
A tibble with NNT estimates and confidence intervals
}
\description{
Converts IPTW risk difference estimates and confidence intervals to causal Number
Needed to Treat using the reciprocal transformation with appropriate handling of
boundary cases and effective sample size considerations.
}
\references{
Laupacis A, Sackett DL, Roberts RS (1988). "An assessment of clinically useful
measures of the consequences of treatment." New England Journal of Medicine,
318(26), 1728-1733. doi:10.1056/NEJM198806303182605

Hernán MA, Robins JM (2020). "Causal Inference: What If." Chapman & Hall/CRC.
}
\keyword{internal}
