% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.transform_to_nnt}
\alias{.transform_to_nnt}
\title{Transform Risk Difference Results to Number Needed to Treat}
\usage{
.transform_to_nnt(rd_results, nnt_threshold = 0.001)
}
\arguments{
\item{rd_results}{A tibble with risk difference results from calc_risk_diff}

\item{nnt_threshold}{Minimum absolute risk difference for meaningful NNT (default: 0.001)}
}
\value{
A tibble with NNT estimates and confidence intervals
}
\description{
Converts risk difference estimates and confidence intervals to Number Needed to Treat (NNT)
using the reciprocal transformation with appropriate handling of boundary cases.
}
\references{
Laupacis A, Sackett DL, Roberts RS (1988). "An assessment of clinically useful
measures of the consequences of treatment." New England Journal of Medicine,
318(26), 1728-1733. doi:10.1056/NEJM198806303182605

Cook RJ, Sackett DL (1995). "The number needed to treat: a clinically useful
measure of treatment effect." BMJ, 310(6977), 452-454. doi:10.1136/bmj.310.6977.452
}
\keyword{internal}
