% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{rxp_qmd}
\alias{rxp_qmd}
\title{Render a Quarto Document as a Nix Derivation}
\usage{
rxp_qmd(
  name,
  qmd_file,
  additional_files = "",
  nix_env = "default.nix",
  args = "",
  env_var = NULL,
  noop_build = FALSE
)
}
\arguments{
\item{name}{Symbol, derivation name.}

\item{qmd_file}{Character, path to .qmd file.}

\item{additional_files}{Character vector, additional files to include, for
example a folder containing images to include in the Quarto document.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{args}{A character of additional arguments to be passed directly to the
\code{quarto} command.}

\item{env_var}{List, defaults to NULL. A named list of environment variables
to set before running the Quarto render command, e.g., c(QUARTO_PROFILE =
"production"). Each entry will be added as an export statement in the build
phase.}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
An object of class derivation which inherits from lists.
}
\description{
Render a Quarto Document as a Nix Derivation
}
\details{
To include built derivations in the document,
\code{rxp_read("derivation_name")} should be put in the .qmd file.
}
\examples{
\dontrun{
  # Compile a .qmd file to a pdf using typst
  # `images` is a folder containing images to include in the Quarto doc
  rxp_qmd(
    name = report,
    qmd_file = "report.qmd",
    additional_files = "images",
    args = "--to typst"
  )

  # Skip building this derivation
  rxp_qmd(
    name = draft_report,
    qmd_file = "draft.qmd",
    noop_build = TRUE
  )
}
}
\seealso{
Other derivations: 
\code{\link{rxp_jl}()},
\code{\link{rxp_jl_file}()},
\code{\link{rxp_py}()},
\code{\link{rxp_py_file}()},
\code{\link{rxp_r}()},
\code{\link{rxp_r_file}()},
\code{\link{rxp_rmd}()}
}
\concept{derivations}
