/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet;

import ec.util.spreadsheet.Book;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class BookFactoryLoader {
    private static final Iterable<Book.Factory> SOURCE = ServiceLoader.load(Book.Factory.class);
    private static final Comparator<Book.Factory> SORTER = Collections.reverseOrder(Comparator.comparingInt(Book.Factory::getRank));
    private static final AtomicReference<List<Book.Factory>> RESOURCE = new AtomicReference<List<Book.Factory>>(BookFactoryLoader.doLoad());
    private static final Consumer<Iterable> CLEANER = loader -> ((ServiceLoader)loader).reload();

    private BookFactoryLoader() {
    }

    private static List<Book.Factory> doLoad() {
        return StreamSupport.stream(SOURCE.spliterator(), false).sorted(SORTER).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<Book.Factory> get() {
        return RESOURCE.get();
    }

    public static void set(List<Book.Factory> newValue) {
        RESOURCE.set(Objects.requireNonNull(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Iterable<Book.Factory> iterable = SOURCE;
        synchronized (iterable) {
            CLEANER.accept(SOURCE);
            BookFactoryLoader.set(BookFactoryLoader.doLoad());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Iterable<Book.Factory> iterable = SOURCE;
        synchronized (iterable) {
            BookFactoryLoader.set(BookFactoryLoader.doLoad());
        }
    }
}

