% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jd3spreadsheet.R
\name{spreadsheet_series}
\alias{spreadsheet_series}
\title{Retrieves a time series from a spreadsheet file.}
\usage{
spreadsheet_series(
  file,
  sheet = 1,
  series = 1,
  gathering.period = 0,
  gathering.aggregation = c("None", "Sum", "Average", "First", "Last", "Max", "Min"),
  gathering.partialAggregation = FALSE,
  gathering.cleanMissing = TRUE,
  fullName = TRUE
)
}
\arguments{
\item{file}{The spreadsheet file.}

\item{sheet}{The name or the 1-based position of the sheet containing the requested data.}

\item{series}{The name or the 1-based position of the series in the selected sheet.}

\item{gathering.period}{The annual frequency of the transformed series. If 0, the actual frequency is used.}

\item{gathering.aggregation}{The type of the aggregation to be applied on the series (only used if "period" is different from 0).}

\item{gathering.partialAggregation}{Specifies if  the aggregation is performed or not when they are missing periods.}

\item{gathering.cleanMissing}{Specifies if missing values are removed at the beginning or at the end of the data.}

\item{fullName}{Specifies if a full name (containing the name of the sheet and the name of the series) is used or not.}
}
\value{
Returns the specified time series.
}
\description{
Retrieves a time series from a spreadsheet file.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
set_spreadsheet_paths(system.file("extdata", package = "rjd3providers"))
xls_s1_3 <- spreadsheet_series("Insee.xlsx", 1, 3)
txt_s1 <- spreadsheet_series("Insee.xlsx", "FRANCE Textile", 1)
}
\dontshow{\}) # examplesIf}
}
