/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.lapack.Cholesky;

public final class SymmetricMatrixLoader {

    public static final class CholeskyProcessor {
        private final Iterable<SymmetricMatrix.CholeskyProcessor> source = ServiceLoader.load(SymmetricMatrix.CholeskyProcessor.class);
        private final AtomicReference<SymmetricMatrix.CholeskyProcessor> resource = new AtomicReference<SymmetricMatrix.CholeskyProcessor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private SymmetricMatrix.CholeskyProcessor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new Cholesky());
        }

        public SymmetricMatrix.CholeskyProcessor get() {
            return this.resource.get();
        }

        public void set(SymmetricMatrix.CholeskyProcessor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<SymmetricMatrix.CholeskyProcessor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<SymmetricMatrix.CholeskyProcessor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

