% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archaeology.R
\name{road_get_symbolic_artifacts}
\alias{road_get_symbolic_artifacts}
\title{Get symbolic artifacts from the ROAD database}
\usage{
road_get_symbolic_artifacts(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  symbolic_artifact_interpretation = NULL,
  assemblages = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe). 
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated 
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")} 
to display possible values.
The argument \code{country} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the 
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age 
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")} 
to display possible values. The argument \code{cultural_period} is a string 
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool 
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes 
human remains, raw material, typology, technology, function, organic tools, 
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains, 
plant remains. The argument \code{category} is a string (one item) or 
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{symbolic_artifact_interpretation}{specifies the interpretation of 
symbolic artifacts (e.g. abstract, anthropomorphic, zoomorphic, instrument, 
ornament). Run \code{road_list_argument_values("symbolic_artifact_interpretation")} 
to display possible values. The argument \code{symbolic_artifact_interpretation} 
is a string (one item) or vector of strings; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}
}
\value{
A data frame with information about symbolic artifacts. Rows represent individual symbolic finds, columns contain details on:

\code{symbolic artifacts category}: List of symbolic categories 
(art, music, ornament).

\code{symbolic artifacts technology}: List of technologies such as: 
painting, engraving, carving, molding, polishing, imprinting, etc.

\code{symbolic artifacts material}: Material of the symbolic artifact, 
for example: antler, bone, cave wall, clay, ivory, ochre, ostrich eggshell.

\code{symbolic artifacts raw material source}: List with specific 
intervals of transport for the raw material used to manufacture the symbolic 
artifact. Five fixed types of raw material source are possible:
\itemize{
  \item local (0-5 km) 
  \item regional (6-20 km)
  \item supra-regional (21-100 km)
  \item distant (>100 km)
  \item unknown
}
}
\description{
The \strong{\code{road_get_symbolic_artifacts}} retrieves data on symbolic artifacts from the ROAD database.
Symbolic artifacts are objects interpreted as having symbolic or cultural significance
in archaeological contexts. This function allows you to query symbolic artifact
data from the ROAD database using parameters such as geographical location,
cultural periods, artifact interpretation, and assemblages. Use the parameters
to filter the results or omit them to retrieve a broader dataset.
}
\examples{
\donttest{road_get_symbolic_artifacts(continent = "Europe", locality_type = "rock shelter", 
                            symbolic_artifact_interpretation = "instrument")}
\donttest{road_get_symbolic_artifacts(subcontinent = "Southern Africa", 
                            symbolic_artifact_interpretation = "zoomorphic")}
}
