% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_stage_results.R
\name{StageResultsMultiArmMeans}
\alias{StageResultsMultiArmMeans}
\title{Stage Results Multi Arm Means}
\description{
Class for stage results of multi arm means data
}
\details{
This object cannot be created directly; use \code{getStageResults}
with suitable arguments to create the stage results of a dataset of multi arm means.
}
\section{Fields}{

\describe{
\item{\code{stages}}{The stage numbers of the trial. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{testStatistics}}{The stage-wise test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{pValues}}{The stage-wise p-values. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{combInverseNormal}}{The test statistics over stages for the inverse normal test. Is a numeric vector of length \code{kMax}.}

\item{\code{combFisher}}{The test statistics over stages for Fisher's combination test. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{effectSizes}}{The stage-wise effect sizes. Is a numeric vector of length \code{kMax}.}

\item{\code{testActions}}{The test decisions at each stage of the trial. Is a character vector of length \code{kMax}.}

\item{\code{weightsFisher}}{The weights for Fisher's combination test. Is a numeric vector of length \code{kMax}.}

\item{\code{weightsInverseNormal}}{The weights for the inverse normal statistic. Is a numeric vector of length \code{kMax}.}

\item{\code{combInverseNormal}}{The test statistics over stages for the inverse normal test. Is a numeric vector of length \code{kMax}.}

\item{\code{combFisher}}{The test statistics over stages for Fisher's combination test. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{overallTestStatistics}}{The overall, i.e., cumulated test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{overallStDevs}}{The overall, i.e., cumulative standard deviations. Is a numeric vector of length number of stages times number of groups.}

\item{\code{overallPooledStDevs}}{The overall pooled standard deviations. Is a numeric matrix.}

\item{\code{overallPValues}}{The overall, i.e., cumulated p-values. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{testStatistics}}{The stage-wise test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{separatePValues}}{The p-values from the separate stages. Is a numeric matrix.}

\item{\code{effectSizes}}{The stage-wise effect sizes. Is a numeric vector of length \code{kMax}.}

\item{\code{singleStepAdjustedPValues}}{The adjusted p-value for testing multiple hypotheses per stage of the trial.}

\item{\code{intersectionTest}}{The multiple test used for intersection hypotheses in closed systems of hypotheses. Is a character vector of length 1.}

\item{\code{varianceOption}}{Defines the way to calculate the variance in multiple (i.e., >2) treatment arms or population enrichment designs when testing means. Available options for multiple arms: \code{"overallPooled", "pairwisePooled", "notPooled"}. Available options for enrichment designs: \code{"pooled", "pooledFromFull", "notPooled"}.}

\item{\code{normalApproximation}}{Describes if a normal approximation was used when calculating p-values. Default for means is \code{FALSE} and \code{TRUE} for rates and hazard ratio. Is a logical vector of length 1.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}
}}

\keyword{internal}
