% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{sixelDecode}
\alias{sixelDecode}
\title{Decode SIXEL escape sequence to image data}
\usage{
sixelDecode(data)
}
\arguments{
\item{data}{character, SIXEL escape sequence.}
}
\value{
A raster array with values ranging from 0 to 1.
The array has dimensions (height, width, 3) where the third dimension
represents the R, G, and B color channels.
}
\description{
Parse a SIXEL escape sequence and convert it to a raster array.
}
\examples{
# read sixel sequence
sixel_file <- system.file("snake.six", package="rsixel")
sixel_data <- readChar(sixel_file, file.info(sixel_file)$size)
img <- sixelDecode(sixel_data)

}
