% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-standalone-df-list-df.R
\name{.transpose}
\alias{.transpose}
\title{Transform a nested dataframe to / from a row by row list}
\usage{
.transpose(x, ..., .fix = ".")
}
\arguments{
\item{x}{a \code{data.frame} or \code{row_list}}

\item{...}{not used}

\item{.fix}{collapse or expand names in redundant multi-level \code{row_list}s.
Either \code{FALSE} or a string to join or split the names of the multi-level
list by}
}
\value{
either a dataframe or a list of class \code{row_list} representing the
dataframe as a list of named lists.
}
\description{
Data frames are column lists, which may have nested dataframes. This function
transforms a data frame to row based list with named sub lists with one entry
per dataframe column (a \code{row_list}). It alternative converts a \code{row_list} back
to a nested data frame
}
\concept{transpose}
\keyword{internal}

\section{Unit tests}{
\if{html}{\out{<div class="sourceCode">}}\preformatted{


# create a test nested data frame:

mtcars_nest = datasets::mtcars %>%
  dplyr::mutate(name = rownames(.)) %>%
  tidyr::nest(by_carb = -c(cyl,gear,carb)) %>%
  tidyr::nest(by_cyl_and_gear = -c(cyl,gear))

mtcars_list = mtcars_nest %>% .transpose()

mtcars_nest2 = mtcars_list %>% .transpose()

testthat::expect_equal(mtcars_nest, mtcars_nest2)
}\if{html}{\out{</div>}}
}

