% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{efficiency}
\alias{efficiency}
\title{Amplification efficiency statistics and standard curves}
\usage{
efficiency(df, base_size = 12, legend_position = c(0.2, 0.2), ...)
}
\arguments{
\item{df}{A data frame containing dilution series and corresponding Ct values.
The first column should represent dilution levels, and the remaining
columns should contain Ct values for different genes.}

\item{base_size}{font size}

\item{legend_position}{legend position}

\item{...}{Additional ggplot2 layer arguments}
}
\value{
A list with the following components:
\describe{
  \item{efficiency}{A data frame containing slope, amplification efficiency (E),
  and R\eqn{^2} statistics for each gene.}
  \item{Slope_compare}{A table comparing slopes between genes.}
  \item{plot}{A \code{ggplot2} object showing standard curves for all genes.}
}
}
\description{
The \code{efficiency} function calculates amplification efficiency (E)
and related statistics, including slope and coefficient of determination
(R\eqn{^2}), and generates standard curves for qPCR assays.
}
\details{
Amplification efficiency is estimated from standard curves generated by
regressing Ct values against the logarithm of template dilution.
For each gene, the function reports the slope of the standard curve,
amplification efficiency (E), and R\eqn{^2} as a measure of goodness of fit.
The function also provides graphical visualization of the standard curves.
}
\examples{

# Load example efficiency data
data <- read.csv(system.file("extdata", "data_efficiency1.csv", package = "rtpcr"))

# Calculate amplification efficiency and generate standard curves
efficiency(data)


ef <- read.csv(system.file("extdata", "data_efficiency_Yuan2006PMCBioinf.csv", package = "rtpcr"))
efficiency(ef)

}
\author{
Ghader Mirzaghaderi
}
