% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gha_python_versions.R
\name{gha_python_versions}
\alias{gha_python_versions}
\title{GitHub Actions python versions}
\usage{
gha_python_versions(
  python_version = NULL,
  versions_explicit = TRUE,
  cache_dir = tools::R_user_dir(package = "rworkflows", which = "cache"),
  verbose = TRUE
)
}
\arguments{
\item{python_version}{Which python version to use on each OS
(e.g. "3.10", "3.7.5", or "3.x").
(\code{NULL} means python will not be installed on that OS).
See 
\href{https://github.com/actions/python-versions}{here} 
or  \code{rworkflows:::gha_python_versions()} for all available 
python versions. 
See 
\href{https://github.com/marketplace/actions/setup-miniconda}{here} for
details on the \code{actions/setup-miniconda} action.
See \href{https://github.com/actions/setup-python}{here} for details on 
the \code{actions/setup-python} action.}

\item{versions_explicit}{Specify R/Bioc versions explicitly
(e.g. \code{r: 4.2.0, bioc: 3.16}) 
as opposed to flexibly (e.g. \code{r: "latest", bioc: "release"}).}

\item{verbose}{Print messages.}
}
\value{
Yaml with info for all versions of python,
 or a character string of one or more versions of python.
}
\description{
Retrieve all python versions available for GitHub Actions runners.
}
\keyword{internal}
