% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asModel.R
\name{as.model}
\alias{as.model}
\alias{as.model.character}
\alias{as.model.call}
\alias{as.model.list}
\alias{as.model.default}
\title{Turn into a model expression}
\usage{
as.model(x)

\method{as.model}{character}(x)

\method{as.model}{call}(x)

\method{as.model}{list}(x)

\method{as.model}{default}(x)
}
\arguments{
\item{x}{item to convert to a \code{model({})} expression}
}
\value{
model expression
}
\description{
Turn into a model expression
}
\examples{

model <- quote(model({
  ka <- exp(tka + eta.ka)
  cl <- exp(tcl + eta.cl)
  v <- exp(tv + eta.v)
  d/dt(depot) = -ka * depot
  d/dt(center) = ka * depot - cl / v * center
  cp = center / v
  cp ~ add(add.sd)
}))

as.model(model)

one.compartment <- function() {
  ini({
    tka <- log(1.57)
    tcl <- log(2.72)
    tv <- log(31.5)
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    d/dt(depot) = -ka * depot
    d/dt(center) = ka * depot - cl / v * center
    cp = center / v
    cp ~ add(add.sd)
  })
}

as.model(one.compartment)

ui <- one.compartment()

as.model(ui)

model <- c("model({",
           "ka <- exp(tka + eta.ka)",
           "cl <- exp(tcl + eta.cl)",
           "v <- exp(tv + eta.v)",
           "d/dt(depot) = -ka * depot",
           "d/dt(center) = ka * depot - cl / v * center",
           "cp = center / v",
           "cp ~ add(add.sd)",
           "})")

as.model(model)

model <- paste(model, collapse="\n")

as.model(model)

}
\author{
Matthew L. Fidler
}
