% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular_write.R
\name{tabular_write}
\alias{tabular_write}
\title{Write tabular data to various formats}
\usage{
tabular_write(object, path, format)
}
\arguments{
\item{object}{A data frame to write}

\item{path}{Character string specifying the output file path}

\item{format}{Character string specifying the format: "delim", "xlsx", "csv", "csv2", "tsv", "sav", "dta"}
}
\value{
Invisibly returns TRUE on success, used for side effects
}
\description{
A wrapper function to write data frames to different file formats
}
\examples{
data <- data.frame(x = 1:3, y = letters[1:3])

# Write as CSV
tabular_write(data, tempfile(fileext = ".csv"), format = "csv")

# Write as Excel
tabular_write(data, tempfile(fileext = ".xlsx"), format = "xlsx")

# Write as SPSS
tabular_write(data, tempfile(fileext = ".sav"), format = "sav")
}
