% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-copy.R
\name{sas_file_copy}
\alias{sas_file_copy}
\title{Copy a file on SAS}
\usage{
sas_file_copy(from_path, to_path)
}
\arguments{
\item{from_path}{string; Path of file on remote SAS server to be copied.}

\item{to_path}{string; Path of file on remote SAS server to copy to.}
}
\value{
\code{logical}; value indicating if the operation succeeded.
}
\description{
Copies a file on the remote SAS server. Is analogous to
\code{file.copy()}, but for the remote SAS server.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# connect to SAS
sas_connect()

# create an example file
local_path <- tempfile(fileext = ".txt")
cat("some example text", file = tempfile_path)

sas_path <- readline(
  "Please provide the full path to upload an example file to (e.g., ~/example.txt)."
)
sas_file_upload(local_path, sas_path)

from_path <- sas_path
to_path <- readline(
  "Please provide the full path to copy the example file to (e.g., ~/example_copy.txt)."
)
sas_file_copy(from_path, to_path)

# cleanup
unlink(local_path)
sas_file_remove(from_path)
sas_file_remove(to_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other file management functions: 
\code{\link{sas_file_download}()},
\code{\link{sas_file_exists}()},
\code{\link{sas_file_remove}()},
\code{\link{sas_file_upload}()},
\code{\link{sas_list}()}
}
\concept{file management functions}
