% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Add_Pct_Diff}
\alias{Add_Pct_Diff}
\title{Add percentage difference to DE results}
\usage{
Add_Pct_Diff(
  marker_dataframe,
  pct.1_name = "pct.1",
  pct.2_name = "pct.2",
  overwrite = FALSE
)
}
\arguments{
\item{marker_dataframe}{data.frame containing the results of \code{\link[Seurat]{FindMarkers}},  \code{\link[Seurat]{FindAllMarkers}}, or other DE test data.frame.}

\item{pct.1_name}{the name of data.frame column corresponding to percent expressed in group 1.
Default is Seurat default "pct.1".}

\item{pct.2_name}{the name of data.frame column corresponding to percent expressed in group 2.
Default is Seurat default "pct.2".}

\item{overwrite}{logical.  If the \code{marker_dataframe} already contains column named "pct_diff" whether to
overwrite or return error message.  Default is FALSE.}
}
\value{
Returns input \code{marker_dataframe} with additional "pct_diff" column.
}
\description{
Adds new column labeled "pct_diff" to the data.frame output of \code{\link[Seurat]{FindMarkers}},  \code{\link[Seurat]{FindAllMarkers}}, or other DE test data.frames.
}
\examples{
\dontrun{
marker_df <- FindAllMarkers(object = obj_name)
marker_df <- Add_Pct_Diff(marker_dataframe = marker_df)
# or piped with function
marker_df <- FindAllMarkers(object = obj_name) \%>\%
  Add_Pct_Diff()
}

}
\concept{marker_annotation_util}
