% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_demographic_table.R
\name{make_demographic_table}
\alias{make_demographic_table}
\title{Create a demographics summary table}
\usage{
make_demographic_table(data, vars, continuous_vars = NULL)
}
\arguments{
\item{data}{A data frame}

\item{vars}{demographic variables to include in the table}

\item{continuous_vars}{Optional subset of vars to be treated as continuous}
}
\value{
A gtsummary table
}
\description{
Create a demographics summary table
}
\examples{
# Minimal example data
df <- data.frame(
  age = c(25, 30, 35),
  sex = c("M", "F", "M"),
  education = c("HS", "BA", "MA")
)

# Generate a demographic summary table (assign to object to avoid printing)
demo_table <- make_demographic_table(df, vars = c("age", "sex", "education"))
demo_table # optionally inspect the table

}
