% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_example.R
\name{read_domain_example}
\alias{read_domain_example}
\title{Read an example SDTM domain}
\usage{
read_domain_example(example)
}
\arguments{
\item{example}{The name of SDTM domain example, e.g. \code{"cm"} (Concomitant
Medication) or \code{"ae"} (Adverse Events). Run \code{read_domain_example()} for
available example files.}
}
\value{
A \link[tibble:tibble-package]{tibble} with an SDTM domain dataset, or a
character vector of example file names.
}
\description{
\code{\link[=read_domain_example]{read_domain_example()}} imports one of the bundled SDTM domain examples
as a \link[tibble:tibble-package]{tibble} into R. See \code{\link[=domain_example]{domain_example()}} for
possible choices.
}
\examples{
# Leave the `example` parameter as missing for available example files.
read_domain_example()

# Read the example Concomitant Medication domain.
read_domain_example("cm")

# Read the example Adverse Events domain.
read_domain_example("ae")

}
\seealso{
\code{\link[=domain_example]{domain_example()}}
}
