% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{base58enc}
\alias{base58enc}
\title{Base58 Encode}
\usage{
base58enc(x, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{convert}{logical \code{TRUE} to encode to a character string or \code{FALSE} to a
raw vector.}
}
\value{
A character string or raw vector depending on the value of \code{convert}.
}
\description{
Encodes a character string, raw vector or other object to base58 encoding
with a 4-byte checksum suffix.
}
\details{
Adds a 4-byte checksum suffix (double SHA-256) to the data before base58
encoding. Note: does not include a version byte prefix (unlike Bitcoin
Base58Check).

A character string or raw vector (with no attributes) is encoded as is,
whilst all other objects are first serialized (using R serialisation version
3, big-endian representation).
}
\examples{
base58enc("secret base")
base58enc(as.raw(c(1L, 2L, 4L)), convert = FALSE)
base58enc(data.frame())

}
\references{
This implementation is based on 'libbase58' by Luke Dashjr under the MIT
licence at \url{https://github.com/luke-jr/libbase58}.
}
\seealso{
\code{\link[=base58dec]{base58dec()}}
}
