% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{cbordec}
\alias{cbordec}
\title{CBOR Decode}
\usage{
cbordec(x)
}
\arguments{
\item{x}{A raw vector containing CBOR-encoded data.}
}
\value{
The decoded R object.
}
\description{
Decode CBOR (Concise Binary Object Representation, RFC 8949) data to an R
object.
}
\details{
CBOR types map to R types as follows:
\itemize{
\item Integers: integer (if within range) or double
\item Float16/Float32/Float64: double
\item Byte strings: raw vectors
\item Text strings: character
\item false/true: logical
\item null: NULL
\item undefined: NA
\item Arrays: lists
\item Maps: named lists (keys must be text strings)
}
}
\examples{
# Round-trip encoding
original <- list(a = 1L, b = "test", c = TRUE)
cbordec(cborenc(original))

}
\seealso{
\code{\link[=cborenc]{cborenc()}}
}
