% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_performance.R
\name{mean_performance}
\alias{mean_performance}
\title{Mean performance of phenotypic data}
\usage{
mean_performance(
  data,
  genotypes,
  replications,
  columns = NULL,
  main_plots = NULL,
  design_type = c("RCBD", "LSD", "SPD"),
  method = c("REML", "Yates", "Healy", "Regression", "Mean", "Bartlett")
)
}
\arguments{
\item{data}{data for analysis}

\item{genotypes}{genotypes vector (sub-plot treatments in SPD)}

\item{replications}{replication vector}

\item{columns}{vector containing columns (required for Latin Square Design only)}

\item{main_plots}{vector containing main plot treatments (required for Split Plot Design only)}

\item{design_type}{experimental design type: "RCBD" (default), "LSD" (Latin Square), or "SPD" (Split Plot)}

\item{method}{Method for missing value imputation: "REML" (default), "Yates", "Healy", "Regression", "Mean", or "Bartlett"}
}
\value{
Dataframe of mean performance analysis
}
\description{
Mean performance of phenotypic data
}
\examples{
mean_performance(data = seldata[, 3:9], genotypes = seldata[, 2], replications = seldata[, 1])

}
