% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen_indices.R
\name{ppg_esim}
\alias{ppg_esim}
\title{Predetermined Proportional Gain Eigen Selection Index (PPG-ESIM)}
\usage{
ppg_esim(pmat, gmat, d, selection_intensity = 2.063)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{d}{Numeric vector of desired proportional gains (length n_traits).
The \emph{ratios} among elements define target gain proportions.
Direction (positive/negative) must reflect desired improvement direction
(positive = increase, negative = decrease).}

\item{selection_intensity}{Selection intensity constant (default: 2.063).}
}
\value{
Object of class \code{"ppg_esim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with beta (transformed b), b (raw), hI2,
    rHI, sigma_I, Delta_G, and lambda2.}
  \item{\code{beta}}{Named numeric vector of post-transformation PPG-ESIM
    coefficients \eqn{\boldsymbol{\beta}_P = \mathbf{F}\mathbf{b}_P}.}
  \item{\code{b}}{Raw eigenvector b_P before similarity transform.}
  \item{\code{Delta_G}}{Named vector of expected genetic gains per trait.}
  \item{\code{sigma_I}}{Index standard deviation.}
  \item{\code{hI2}}{Index heritability.}
  \item{\code{rHI}}{Index accuracy.}
  \item{\code{lambda2}}{Leading eigenvalue of the PPG restricted eigenproblem.}
  \item{\code{F_mat}}{Diagonal similarity transform matrix F (diag(sign(d))).}
  \item{\code{K_P}}{PPG projection matrix (rank 1: projects onto d subspace).}
  \item{\code{D_M}}{Mallard matrix (t x t-1): orthogonal complement of d,
    used to construct the (t-1) restrictions.}
  \item{\code{desired_gains}}{Input proportional gains vector d.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Extends ESIM by enforcing that genetic gains are proportional to a
user-specified vector \eqn{\mathbf{d}}: \eqn{\Delta\mathbf{G} \propto \mathbf{d}}.
A similarity transformation \eqn{\boldsymbol{\beta}_P = \mathbf{F}\mathbf{b}_P}
aligns the eigenvector with the breeder's desired direction.
}
\details{
\strong{Restriction structure via the Mallard Matrix (Section 7.3):}

The PPG-ESIM restricts the \eqn{(t-1)} directions **orthogonal** to \eqn{\mathbf{d}},
forcing the genetic gain vector to be collinear with \eqn{\mathbf{d}}.

The Mallard matrix \eqn{\mathbf{D}_M} is \eqn{t \times (t-1)}: its columns span
the orthogonal complement of \eqn{\mathbf{d}}, obtained via QR decomposition of
\eqn{\mathbf{d}/\|\mathbf{d}\|}:
\deqn{\mathbf{Q}_{QR} = [\hat{d} \mid \mathbf{D}_M], \quad
      \text{QR}(\hat{d}) \to \mathbf{Q}_{QR} \in \mathbb{R}^{t \times t}}

With \eqn{\boldsymbol{\Psi} = \mathbf{C}} (full-trait case, \eqn{\mathbf{U} = \mathbf{I}_t}):

\strong{PPG projection matrix (\eqn{t-1} restrictions):}
\deqn{\mathbf{Q}_P =
  \mathbf{P}^{-1}\boldsymbol{\Psi}\mathbf{D}_M
  (\mathbf{D}_M^{\prime}\boldsymbol{\Psi}^{\prime}\mathbf{P}^{-1}\boldsymbol{\Psi}\mathbf{D}_M)^{-1}
  \mathbf{D}_M^{\prime}\boldsymbol{\Psi}^{\prime}}
\deqn{\mathbf{K}_P = \mathbf{I}_t - \mathbf{Q}_P \quad (\text{rank 1})}

Because \eqn{\mathbf{K}_P} has rank 1 (projects onto the \eqn{\mathbf{d}} subspace),
\eqn{\mathbf{K}_P\mathbf{P}^{-1}\mathbf{C}} has exactly one positive eigenvalue and
its eigenvector produces \eqn{\Delta\mathbf{G} \propto \mathbf{d}}.

\strong{PPG eigenproblem (rank-1 system):}
\deqn{(\mathbf{K}_P\mathbf{P}^{-1}\mathbf{C} - \lambda_P^2\mathbf{I}_t)\mathbf{b}_P = 0}

\strong{Similarity transform:}
\deqn{\boldsymbol{\beta}_P = \mathbf{F}\mathbf{b}_P}
where \eqn{\mathbf{F} = \text{diag}(\text{sign}(\mathbf{d}))} aligns the
eigenvector sign with the breeder's intended improvement direction.

\strong{Key response metrics:}
\deqn{R_P = k_I\sqrt{\boldsymbol{\beta}_P^{\prime}\mathbf{P}\boldsymbol{\beta}_P}}
\deqn{\mathbf{E}_P = k_I\frac{\mathbf{C}\boldsymbol{\beta}_P}{\sqrt{\boldsymbol{\beta}_P^{\prime}\mathbf{P}\boldsymbol{\beta}_P}}}
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Desired proportional gains: increase all traits proportionally
d <- c(2, 1, 1, 1, 1, 1, 1)
result <- ppg_esim(pmat, gmat, d)
print(result)
summary(result)
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 7.3.
}
