% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{stochastic_simulation}
\alias{stochastic_simulation}
\title{Stochastic Simulation of Selection Indices (Chapter 10)}
\description{
Implements stochastic simulation methods for evaluating the long-term
performance of selection indices over multiple breeding cycles.
These methods model linkage between loci using Haldane's mapping function
and track genetic gain across generations.

Methods included:
- Haldane's mapping function for recombination
- Multi-cycle simulation framework
- Comparisons of LPSI, ESIM, RLPSI, and RESIM over time
}
\references{
Haldane, J. B. S. (1919). The combination of linkage values and the calculation
of distances between the loci of linked factors. Journal of Genetics, 8(29), 299-309.

Smith, H. F. (1936). A discriminant function for plant selection.
Annals of Eugenics, 7(3), 240-250.

Hazel, L. N. (1943). The genetic basis for constructing selection indexes.
Genetics, 28(6), 476.

Kempthorne, O., & Nordskog, A. W. (1959). Restricted selection indices.
Biometrics, 15(1), 10-19.

Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Chapter 7 & 10.
}
\keyword{internal}
