% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes__OAuthToken.R
\name{OAuthToken}
\alias{OAuthToken}
\title{OAuthToken S7 class}
\usage{
OAuthToken(
  access_token = character(0),
  refresh_token = NA_character_,
  id_token = NA_character_,
  expires_at = Inf,
  userinfo = list(),
  id_token_validated = FALSE
)
}
\arguments{
\item{access_token}{Access token}

\item{refresh_token}{Refresh token (if provided by the provider)}

\item{id_token}{ID token (if provided by the provider; OpenID Connect)}

\item{expires_at}{Numeric timestamp (seconds since epoch) when the access
token expires. \code{Inf} for non-expiring tokens}

\item{userinfo}{List containing user information fetched from the provider's
userinfo endpoint (if fetched)}

\item{id_token_validated}{Logical flag indicating whether the ID token was
cryptographically validated (signature verified and standard claims checked)
during the OAuth flow. Defaults to \code{FALSE}.}
}
\description{
S7 class representing OAuth tokens and (optionally) user information.
}
\details{
The \code{id_token_claims} property is a read-only computed property that returns
the decoded JWT payload of the ID token as a named list. This surfaces all
standard and optional OIDC claims (e.g., \code{sub}, \code{iss}, \code{aud}, \code{acr}, \code{amr},
\code{auth_time}, \code{nonce}, \code{at_hash}, etc.) without requiring manual JWT
decoding. Returns an empty list when no ID token is present or if the token
cannot be decoded.

Note: \code{id_token_claims} always decodes the JWT payload regardless
of whether the ID token's signature was verified.
Check the \code{id_token_validated} property to determine whether the claims
were cryptographically validated.
}
\examples{
# Please note: `get_userinfo()`, `introspect_token()`, and `refresh_token()`
# are typically not called by users of this package directly, but are called
# internally by `oauth_module_server()`. These functions are exported
# nonetheless for advanced use cases. Most users will not need to
# call these functions directly

# Example requires a real token from a completed OAuth flow
# (code is therefore not run; would error with placeholder values below)
\dontrun{
# Define client
client <- oauth_client(
  provider = oauth_provider_github(),
  client_id = Sys.getenv("GITHUB_OAUTH_CLIENT_ID"),
  client_secret = Sys.getenv("GITHUB_OAUTH_CLIENT_SECRET"),
  redirect_uri = "http://127.0.0.1:8100"
)

# Have a valid OAuthToken object; fake example below
# (typically provided by `oauth_module_server()` or `handle_callback()`)
token <- handle_callback(client, "<code>", "<payload>", "<browser_token>")

# Get userinfo
user_info <- get_userinfo(client, token)

# Introspect token (if supported by provider)
introspection <- introspect_token(client, token)

# Refresh token
new_token <- refresh_token(client, token, introspect = TRUE)
}
}
