% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-ssm-mean-eta.R
\name{SSMMeanEta}
\alias{SSMMeanEta}
\title{Steady-State Mean Vector for the
Latent Variables in the
State Space Model}
\usage{
SSMMeanEta(beta, alpha)
}
\arguments{
\item{beta}{Numeric matrix.
Transition matrix relating the values of the latent variables
at the previous to the current time point
(\eqn{\boldsymbol{\beta}}).}

\item{alpha}{Numeric vector.
Vector of constant values for the dynamic model
(\eqn{\boldsymbol{\alpha}}).}
}
\description{
The steady-state mean vector
for the latent variables
in the state space model
\eqn{\mathrm{Mean} \left( \boldsymbol{\eta} \right)}
is given by
\deqn{
  \mathrm{Mean} \left( \boldsymbol{\eta} \right)
  =
  \left(
    \mathbf{I} - \boldsymbol{\beta}
  \right)^{-1}
  \boldsymbol{\alpha}
}
where
\eqn{\boldsymbol{\beta}}
is the transition matrix relating the values of the latent variables
at the previous to the current time point,
\eqn{\boldsymbol{\alpha}}
is a vector of constant values for the dynamic model,
and
\eqn{\mathbf{I}}
is an identity matrix.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0.0, 0.0, 0.5
  ),
  nrow = 3
)
alpha <- rep(x = 1, times = 3)
SSMMeanEta(
  beta = beta,
  alpha = alpha
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptEta}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
