% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSurvData.R
\name{simSurvData}
\alias{simSurvData}
\title{Simulate Survival Data}
\usage{
simSurvData(N, beta = NULL, eta = rep(0.1, 2), nu = rep(1.1, 2), cens = 1, ...)
}
\arguments{
\item{N}{Numeric scalar. Number of individuals to simulate.}

\item{beta}{Numeric 2x2 matrix specifying effects of baseline covariates \code{L0} and \code{A0} on censoring and event hazards.
\itemize{
\item Rows correspond to covariates \code{L0} and \code{A0}.
\item Columns correspond to censoring (1st column) and event (2nd column).
Defaults to zero matrix if \code{NULL}.
}}

\item{eta}{Numeric vector of length 2. Shape parameters for Weibull hazard with parameterization \eqn{\eta \nu t^{\nu - 1}}.
Defaults to \code{rep(0.1, 2)}.}

\item{nu}{Numeric vector of length 2. Scale parameters for the Weibull hazard. Defaults to \code{rep(1.1, 2)}.}

\item{cens}{Numeric binary indicator (0 or 1) specifying if censoring is included (default 1).}

\item{...}{Additional arguments passed to \code{simEventData}, including the argument \code{add_cov} to specify extra covariates.}
}
\value{
Data frame containing the simulated survival data
}
\description{
Simulate Survival Data with Censoring and Event Times
}
\details{
Simulates survival data for \eqn{N} individuals who are at risk for censoring (0) and an event (1).
The hazard functions for censoring and event times follow Weibull distributions parameterized by
shape parameters \eqn{\eta} and scale parameters \eqn{\nu}. Covariate effects on censoring and event
hazards are specified via a matrix \code{beta}.
}
\examples{
simSurvData(10)

}
