% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cuttings}
\alias{cuttings}
\title{Effect of type and size of cutting on willow yield}
\format{
A data frame with 6 variables: \code{ID}, \code{Block}, \code{Plot}, \code{Type}, \code{Size}, \code{Yield}.
\describe{
  \item{ID}{Integer. Unique identifier for each plot/observation.}
  \item{Block}{Factor. Block number in the randomized complete block design.}
  \item{Plot}{Factor. Plot number within each block.}
  \item{Type}{Factor. Cutting type (A, B, C, D, E) planted in each plot.}
  \item{Size}{Factor. Cutting size category: S (small), M (medium), or L (large).}
  \item{Yield}{Numeric. Willow yield measured at the end of the first year (units as recorded, e.g., g/plot or kg/plot).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
cuttings
}
\description{
This field experiment was conducted to assess whether the type of cutting planted influences the growth and yield of willows, while also considering the effect of initial cutting size. Five different cutting types (Type: A–E) and three cutting sizes (Size: S, M, L) were included, though not all type × size combinations were available. The study employed a randomized complete block design with five blocks (Block) based on cutting type, and the 25 plots were arranged to balance cutting sizes as much as possible across blocks and types. The yield (Yield) measured at the end of the first year served as the response variable, enabling analysis of both main and combined effects of cutting type and size on willow growth.
}
\examples{
anova(lm(Yield ~ Block + Size * Type, data = cuttings))
}
\keyword{datasets}
