% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{herbicide}
\alias{herbicide}
\title{Herbicide efficacy}
\format{
A data frame with 7 variables: \code{ID}, \code{Rep}, \code{DPot}, \code{Population}, \code{Type}, \code{Herbicide}, \code{Fwt}.
\describe{
  \item{ID}{Factor. Unique identifier for each pot (experimental unit).}
  \item{Rep}{Factor. Block number in the randomized complete block design corresponding to replicate (1–5).}
  \item{DPot}{Factor. Dummy variable indicating the pot number within each block.}
  \item{Population}{Factor. Identifier for the black-grass population (e.g., "P1"–"P9").}
  \item{Type}{Factor. Chemical group of the applied herbicide (1: group for Herbicides A and C, 2: group for Herbicide B).}
  \item{Herbicide}{Factor. Applied herbicide treatment ("A", "B", or "C").}
  \item{Fwt}{Numeric. Total fresh weight (in grams) of six black-grass plants grown in the pot.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}

R. Hull, Rothamsted Research.
}
\usage{
herbicide
}
\description{
A factorial experiment was conducted to evaluate the efficacy of three herbicides (Herbicide) across nine different populations of black-grass (Population). Herbicides A and C belong to the same chemical group (Type 1), while herbicide B represents a different group (Type 2). The experiment followed a randomized complete block design with five replicates (Rep), each comprising 27 pots (dummy factor DPot). Six plants were grown per pot, and their combined fresh weight (Fwt, in grams) was measured at the conclusion of the study. The dataset allows investigation of differences in herbicide efficacy both between and within herbicide groups, as well as variation in response among different black-grass populations.
}
\examples{
aov(sqrt(Fwt) ~ Herbicide * Population + Error(Rep/DPot), data = herbicide)

}
\keyword{datasets}
