% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{accuracy.smooth}
\alias{accuracy.smooth}
\alias{accuracy.smooth.forecast}
\title{Error measures for an estimated model}
\usage{
\method{accuracy}{smooth}(object, holdout = NULL, ...)

\method{accuracy}{smooth.forecast}(object, holdout = NULL, ...)
}
\arguments{
\item{object}{The estimated model or a forecast from the estimated model generated via
either \code{predict()} or \code{forecast()} functions.}

\item{holdout}{The vector of values of the response variable in the holdout (test) set.
If not provided, then the function will return the in-sample error measures. If the
\code{holdout=TRUE} parameter was used in the estimation of a model, the holdout values
will be extracted automatically.}

\item{...}{Other variables passed to the \code{forecast()} function (e.g. \code{newdata}).}
}
\description{
Function produces error measures for the provided object and the holdout values of the
response variable. Note that instead of parameters \code{x}, \code{test}, the function
accepts the vector of values in \code{holdout}. Also, the parameters \code{d} and \code{D}
are not supported - MASE is always calculated via division by first differences.
}
\details{
The function is a wrapper for the \link[greybox]{measures} function and is implemented
for convenience.
}
\examples{

y <- rnorm(100, 100, 10)
ourModel <- adam(y, holdout=TRUE, h=10)
accuracy(ourModel)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
