% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam-gum.R, R/autogum.R
\name{gum}
\alias{gum}
\alias{auto.gum}
\title{Generalised Univariate Model}
\usage{
gum(y, orders = c(1, 1), lags = c(1, frequency(y)), type = c("additive",
  "multiplicative"), initial = c("backcasting", "optimal", "two-stage",
  "complete"), persistence = NULL, transition = NULL,
  measurement = rep(1, sum(orders)), loss = c("likelihood", "MSE", "MAE",
  "HAM", "MSEh", "TMSE", "GTMSE", "MSCE", "GPL"), h = 0, holdout = FALSE,
  bounds = c("usual", "admissible", "none"), silent = TRUE, model = NULL,
  xreg = NULL, regressors = c("use", "select", "adapt", "integrate"),
  initialX = NULL, ...)

auto.gum(y, orders = 3, lags = frequency(y), type = c("additive",
  "multiplicative", "select"), initial = c("backcasting", "optimal",
  "two-stage", "complete"), ic = c("AICc", "AIC", "BIC", "BICc"),
  loss = c("likelihood", "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE",
  "MSCE", "GPL"), h = 0, holdout = FALSE, bounds = c("usual",
  "admissible", "none"), silent = TRUE, xreg = NULL,
  regressors = c("use", "select", "adapt", "integrate"), ...)
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be forecasted.}

\item{orders}{Order of the model. Specified as vector of number of states
with different lags. For example, \code{orders=c(1,1)} means that there are
two states: one of the first lag type, the second of the second type.
In case of \code{auto.gum()}, this parameters is the value of the max order
to check.}

\item{lags}{Defines lags for the corresponding orders. If, for example,
\code{orders=c(1,1)} and lags are defined as \code{lags=c(1,12)}, then the
model will have two states: the first will have lag 1 and the second will
have lag 12. The length of \code{lags} must correspond to the length of
\code{orders}. In case of the \code{auto.gum()}, the value of the maximum
lag to check. This should usually be a maximum frequency of the data.}

\item{type}{Type of model. Can either be \code{"additive"} or
\code{"multiplicative"}. The latter means that the GUM is fitted on
log-transformed data. In case of \code{auto.gum()}, can also be \code{"select"},
implying automatic selection of the type.}

\item{initial}{Can be either character or a list, or a vector of initial states.
If it is character, then it can be \code{"backcasting"}, meaning that the initials of
dynamic part of the model are produced using backcasting procedure (advised
for data with high frequency), or \code{"optimal"}, meaning that all initial
states are optimised, or \code{"two-stage"}, meaning that optimisation is done
after the backcasting, refining the states. In case of backcasting, the parameters of the
explanatory variables are optimised. Alternatively, you can set \code{initial="complete"}
backcasting, which means that all states (including explanatory variables) are initialised
via backcasting.}

\item{persistence}{Persistence vector \eqn{g}, containing smoothing
parameters. If \code{NULL}, then estimated.}

\item{transition}{Transition matrix \eqn{F}. Can be provided as a vector.
Matrix will be formed using the default \code{matrix(transition,nc,nc)},
where \code{nc} is the number of components in the state vector. If
\code{NULL}, then estimated.}

\item{measurement}{Measurement vector \eqn{w}. If \code{NULL}, then
estimated.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be: \code{likelihood} (assuming Normal distribution of error term),
\code{MSE} (Mean Squared Error), \code{MAE} (Mean Absolute Error),
\code{HAM} (Half Absolute Moment), \code{TMSE} - Trace Mean Squared Error,
\code{GTMSE} - Geometric Trace Mean Squared Error, \code{MSEh} - optimisation
using only h-steps ahead error, \code{MSCE} - Mean Squared Cumulative Error.
If \code{loss!="MSE"}, then likelihood and model selection is done based
on equivalent \code{MSE}. Model selection in this cases becomes not optimal.

There are also available analytical approximations for multistep functions:
\code{aMSEh}, \code{aTMSE} and \code{aGTMSE}. These can be useful in cases
of small samples.

Finally, just for fun the absolute and half analogues of multistep estimators
are available: \code{MAEh}, \code{TMAE}, \code{GTMAE}, \code{MACE}, \code{TMAE},
\code{HAMh}, \code{THAM}, \code{GTHAM}, \code{CHAM}.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{bounds}{The type of bounds for the parameters to use in the model
estimation. Can be either \code{admissible} - guaranteeing the stability of the
model, \code{"usual"} restrict all the parameters with the (0, 1) region,
or \code{none} - no restrictions (potentially dangerous).}

\item{silent}{accepts \code{TRUE} and \code{FALSE}. If FALSE, the function
will print its progress and produce a plot at the end.}

\item{model}{A previously estimated GUM model, if provided, the function
will not estimate anything and will use all its parameters.}

\item{xreg}{The vector (either numeric or time series) or the matrix (or
data.frame) of exogenous variables that should be included in the model. If
matrix included than columns should contain variables and rows - observations.
Note that \code{xreg} should have number of observations equal either to
in-sample or to the whole series. If the number of observations in
\code{xreg} is equal to in-sample, then values for the holdout sample are
produced using \link[smooth]{es} function.}

\item{regressors}{The variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.}

\item{initialX}{The vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{...}{Other non-documented parameters. See \link[smooth]{adam} for
details.  However, there are several unique parameters passed to the optimiser
in comparison with \code{adam}:
1. \code{algorithm0}, which defines what algorithm to use in nloptr for the initial
optimisation. By default, this is "NLOPT_LN_BOBYQA".
2. \code{algorithm} determines the second optimiser. By default this is
"NLOPT_LN_NELDERMEAD".
3. maxeval0 and maxeval, that determine the number of iterations for the two
optimisers. By default, \code{maxeval0=maxeval=40*k}, where
k is the number of estimated parameters.
4. xtol_rel0 and xtol_rel, which are 1e-8 and 1e-6 respectively.
There are also ftol_rel0, ftol_rel, ftol_abs0 and ftol_abs, which by default
are set to values explained in the \code{nloptr.print.options()} function.}

\item{ic}{The information criterion used in the model selection procedure.}
}
\value{
Object of class "adam" is returned with similar elements to the
\link[smooth]{adam} function.
}
\description{
Function constructs Generalised Univariate Model, estimating matrices F, w,
vector g and initial parameters.
}
\details{
The function estimates the Single Source of Error state space model of the
following type:

\deqn{y_{t} = w_t' v_{t-l} + \epsilon_{t}}

\deqn{v_{t} = F v_{t-l} + g_{t} \epsilon_{t}}

where \eqn{v_{t}} is the state vector (defined using \code{orders}) and
\eqn{l} is the vector of \code{lags}, \eqn{w_t} is the \code{measurement}
vector (which includes fixed elements and explanatory variables),
\eqn{F} is the \code{transition} matrix, \eqn{g_t} is the \code{persistence}
vector (includes explanatory variables as well if provided), finally,
\eqn{\epsilon_{t}} is the error term.

For some more information about the model and its implementation, see the
vignette: \code{vignette("gum","smooth")}
}
\examples{
gum(BJsales, h=8, holdout=TRUE)

\donttest{ourModel <- gum(rnorm(118,100,3), orders=c(2,1), lags=c(1,4), h=18, holdout=TRUE)}

# Redo previous model on a new data and produce prediction interval
\donttest{gum(rnorm(118,100,3), model=ourModel, h=18)}

# Produce something crazy with optimal initials (not recommended)
\donttest{gum(rnorm(118,100,3), orders=c(1,1,1), lags=c(1,3,5), h=18, holdout=TRUE, initial="o")}

# Simpler model estimated using trace forecast error loss function and its analytical analogue
\donttest{gum(rnorm(118,100,3), orders=c(1), lags=c(1), h=18, holdout=TRUE, bounds="n", loss="TMSE")}


x <- rnorm(50,100,3)

# The best GUM model for the data
ourModel <- auto.gum(x, orders=2, lags=4, h=18, holdout=TRUE)

\donttest{summary(ourModel)}

}
\references{
\itemize{
\item Svetunkov I. (2023) Smooth forecasting with the smooth package in R. arXiv:2301.01790.
\doi{10.48550/arXiv.2301.01790}.
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://openforecast.org/category/r-en/smooth/}.
}

\itemize{
\item Svetunkov, I., 2023. Smooth Forecasting with the Smooth Package in R. arXiv.
\doi{10.48550/arXiv.2301.01790}
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}
}
\seealso{
\code{\link[smooth]{adam}, \link[smooth]{es}, \link[smooth]{ces}}

\code{\link[smooth]{gum}, \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{sim.es}, \link[smooth]{ssarima}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
