% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{get_CI}
\alias{get_CI}
\title{Bootstrap-based confidence intervals}
\usage{
get_CI(
  ipw_res,
  data,
  n_boot,
  conf_level = 0.95,
  reference_z_value,
  contrast_type = "difference",
  show_progress = TRUE
)
}
\arguments{
\item{ipw_res}{Output from the \code{ipw} function.}

\item{data}{Data table containing the observed data}

\item{n_boot}{Numeric scalar specifying the number of bootstrap replicates to use}

\item{conf_level}{Numeric scalar specifying the confidence level for the confidence intervals. The default is \code{0.95}.}

\item{reference_z_value}{Scalar specifying the value of \eqn{z} considered as the reference level when forming contrasts. See also argument \code{contrast_type}.}

\item{contrast_type}{Character string specifying the type of contrast. The options are \code{"difference"} (for the difference of means/probabilities) and \code{"ratio"} (for the ratio of means/probabilities).}

\item{show_progress}{Logical scalar specifying whether to show a progress bar.}
}
\value{
An object of class "ipw_ci". This object is a list that includes the following components:
\item{res_boot}{A list where each component corresponds to a different medication \eqn{z} level. Each component of the list is a data frame containing the estimates and confidence intervals for the counterfactual outcome mean/probability under the treatment regime indexed by \eqn{z}.}
\item{res_boot_contrast}{A list where each component corresponds to a different medication \eqn{z} level. Each component of the list is a data frame containing the estimates and confidence intervals for the contrast (difference or ratio) counterfactual outcome mean/probability under the treatment regime indexed by \eqn{z} compared to the counterfactual outcome mean/probability under the treatment regime indexed by the reference value.}
\item{res_boot_all}{A three dimensional array containing all the bootstrap replicates. The first dimension corresponds to the bootstrap replicate; The second dimension corresponds to the time interval; The third dimension corresponds to the medication \eqn{z} level.}
\item{outcome_type}{Character string indicating whether the outcome is "continuous" or "binary".}
\item{outcome_times}{Numeric vector of outcome times.}
\item{n_boot}{Number of bootstrap replicates used.}
\item{conf_level}{Confidence level used.}
\item{reference_z_value}{Reference value of Z used for contrasts.}
\item{contrast_type}{Type of contrast ("difference" or "ratio").}
}
\description{
This function applies nonparametric bootstrap to construct confidence intervals around the counterfactual mean/probability estimates obtained by \code{\link{ipw}}.
}
\details{
This function applies nonparametric bootstrap resampling to construct confidence intervals around the counterfactual mean/probability estimates obtained by \code{\link{ipw}}. Bootstrap confidence intervals are constructed by resampling individuals (with replacement) from the original data set, applying the \code{ipw} function to each bootstrap sample, and computing percentile-based confidence intervals from the distribution of bootstrap estimates.
}
\examples{
\donttest{
set.seed(1234)
data_null_processed <- prep_data(data = data_null, grace_period_length = 2,
                                 baseline_vars = 'L')
res_est <- ipw(data = data_null_processed,
               time_smoothed = TRUE,
               outcome_times = c(6, 12, 18, 24),
               A_model = A ~ L + Z,
               R_model_numerator = R ~ L_baseline + Z,
               R_model_denominator = R ~ L + A + Z,
               Y_model = Y ~ L_baseline * (time + Z))
res_ci <- get_CI(ipw_res = res_est, data = data_null_processed, n_boot = 10)
res_ci
}


}
