% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer.R
\name{flux}
\alias{flux}
\title{Apply trophic flux from a resource layer}
\usage{
flux(raster, intakes, from, to)
}
\arguments{
\item{raster}{A \code{SpatRaster} (or similar) representing exposure from the resource.}

\item{intakes}{A \code{trophic_tbl} object that must contain a column
\code{normalized_weight} and a column \code{flux}.}

\item{from}{Character string, name of the source node.}

\item{to}{Character string, name of the target node.}
}
\value{
A raster object with transformed values.
}
\description{
Computes the contribution of a resource raster to a consumer layer using
the normalized weight and a flux function stored in the trophic table.
}
\details{
The function extracts the link corresponding to \code{from -> to} from the
trophic table and applies:
\enumerate{
  \item the associated flux function to the raster values
  \item the normalized weight of the link
}

An error is thrown if no such link exists.
}
