% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cite.R
\name{spod_cite}
\alias{spod_cite}
\title{Cite the package and the data}
\usage{
spod_cite(what = "all", format = "all")
}
\arguments{
\item{what}{Character vector specifying what to cite.
Can include "package", "data", "methodology_v1", "methodology_v2", or "all".
Default is "all".}

\item{format}{Character vector specifying output format(s).
Can include "text", "markdown", "bibtex", or "all".
Default is "all".}
}
\value{
Nothing. Prints citation in plain text, markdown, BibTeX, or all formats at once to console.
}
\description{
Cite the package and the data
}
\examples{
# Cite everything in all formats
\dontrun{
spod_cite()
}

# Cite just the package in BibTeX format
\dontrun{
spod_cite(what = "package", format = "bibtex")
}

# Cite both methodologies in plain text
\dontrun{
spod_cite(what = c("methodology_v1", "methodology_v2"), format = "text")
}
}
