% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb-helpers.R
\name{spod_duckdb_od}
\alias{spod_duckdb_od}
\title{Creates a duckdb connection to origin-destination data}
\usage{
spod_duckdb_od(
  con = DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:", read_only = FALSE),
  zones = c("districts", "dist", "distr", "distritos", "municipalities", "muni",
    "municip", "municipios", "lua", "large_urban_areas", "gau", "grandes_areas_urbanas"),
  ver = NULL,
  data_dir = spod_get_data_dir()
)
}
\arguments{
\item{con}{A duckdb connection object. If not specified, a new in-memory connection will be created.}

\item{zones}{The zones for which to download the data. Can be \code{"districts"} (or \code{"dist"}, \code{"distr"}, or the original Spanish \code{"distritos"}) or \code{"municipalities"} (or \code{"muni"}, \code{"municip"}, or the original Spanish \code{"municipios"}) for both data versions. Additionaly, these can be \code{"large_urban_areas"} (or \code{"lua"}, or the original Spanish \code{"grandes_areas_urbanas"}, or \code{"gau"}) for v2 data (2022 onwards).}

\item{ver}{Integer. Can be 1 or 2. The version of the data to use. v1 spans 2020-2021, v2 covers 2022 and onwards. See more details in codebooks with \code{\link[=spod_codebook]{spod_codebook()}}.}

\item{data_dir}{The directory where the data is stored. Defaults to the value returned by \code{spod_get_data_dir()}.}
}
\value{
A \code{duckdb} connection object with 2 views:
\itemize{
\item \code{od_csv_raw} - a raw table view of all cached CSV files with the origin-destination data that has been previously cached in $SPANISH_OD_DATA_DIR
\item \code{od_csv_clean} - a cleaned-up table view of \code{od_csv_raw} with column names and values translated and mapped to English. This still includes all cached data.
}

The structure of the cleaned-up views \code{od_csv_clean} is as follows:

\describe{
\item{date}{\code{Date}. The full date of the trip, including year, month, and day.}
\item{id_origin}{\code{factor}. The identifier for the origin location of the trip, formatted as a code (e.g., '01001_AM').}
\item{id_destination}{\code{factor}. The identifier for the destination location of the trip, formatted as a code (e.g., '01001_AM').}
\item{activity_origin}{\code{factor}. The type of activity at the origin location (e.g., 'home', 'work'). \strong{Note:} Only available for district level data.}
\item{activity_destination}{\code{factor}. The type of activity at the destination location (e.g., 'home', 'other'). \strong{Note:} Only available for district level data.}
\item{residence_province_ine_code}{\code{factor}. The province of residence for the group of individual making the trip, encoded according to the INE classification. \strong{Note:} Only available for district level data.}
\item{residence_province_name}{\code{factor}. The province of residence for the group of individuals making the trip (e.g., 'Cuenca', 'Girona'). \strong{Note:} Only available for district level data.}
\item{hour}{\code{integer}. The time slot (the hour of the day) during which the trip started, represented as an integer (e.g., 0, 1, 2).}
\item{distance}{\code{factor}. The distance category of the trip, represented as a code (e.g., '002-005' for 2-5 km).}
\item{n_trips}{\code{double}. The number of trips taken within the specified time slot and distance.}
\item{trips_total_length_km}{\code{double}. The total length of all trips in kilometers for the specified time slot and distance.}
\item{year}{\code{double}. The year of the trip.}
\item{month}{\code{double}. The month of the trip.}
\item{day}{\code{double}. The day of the trip.}
}

The structure of the original data in \code{od_csv_raw} is as follows:

\describe{
\item{fecha}{\code{Date}. The date of the trip, including year, month, and day.}
\item{origen}{\code{character}. The identifier for the origin location of the trip, formatted as a character string (e.g., '01001_AM').}
\item{destino}{\code{character}. The identifier for the destination location of the trip, formatted as a character string (e.g., '01001_AM').}
\item{actividad_origen}{\code{character}. The type of activity at the origin location (e.g., 'casa', 'trabajo').}
\item{actividad_destino}{\code{character}. The type of activity at the destination location (e.g., 'otros', 'trabajo').}
\item{residencia}{\code{character}. The code representing the residence of the individual making the trip (e.g., '01') according to the official INE classification.}
\item{edad}{\code{character}. The age of the individual making the trip. This data is actaully filled with 'NA' values, which is why this column is removed in the cleaned-up and translated view described above.}
\item{periodo}{\code{integer}. The time period during which the trip started, represented as an integer (e.g., 0, 1, 2).}
\item{distancia}{\code{character}. The distance category of the trip, represented as a character string (e.g., '002-005' for 2-5 km).}
\item{viajes}{\code{double}. The number of trips taken within the specified time period and distance.}
\item{viajes_km}{\code{double}. The total length of all trips in kilometers for the specified time period and distance.}
\item{day}{\code{double}. The day of the trip.}
\item{month}{\code{double}. The month of the trip.}
\item{year}{\code{double}. The year of the trip.}
}
}
\description{
This function creates a duckdb connection to the origin-destination data stored in CSV.gz files.
}
\keyword{internal}
