% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_stat.R
\name{sdf_rbeta}
\alias{sdf_rbeta}
\title{Generate random samples from a Beta distribution}
\usage{
sdf_rbeta(
  sc,
  n,
  shape1,
  shape2,
  num_partitions = NULL,
  seed = NULL,
  output_col = "x"
)
}
\arguments{
\item{sc}{A Spark connection.}

\item{n}{Sample Size (default: 1000).}

\item{shape1}{Non-negative parameter (alpha) of the Beta distribution.}

\item{shape2}{Non-negative parameter (beta) of the Beta distribution.}

\item{num_partitions}{Number of partitions in the resulting Spark dataframe
(default: default parallelism of the Spark cluster).}

\item{seed}{Random seed (default: a random long integer).}

\item{output_col}{Name of the output column containing sample values (default: "x").}
}
\description{
Generator method for creating a single-column Spark dataframes comprised of
i.i.d. samples from a Betal distribution.
}
\seealso{
Other Spark statistical routines: 
\code{\link{sdf_rbinom}()},
\code{\link{sdf_rcauchy}()},
\code{\link{sdf_rchisq}()},
\code{\link{sdf_rexp}()},
\code{\link{sdf_rgamma}()},
\code{\link{sdf_rgeom}()},
\code{\link{sdf_rhyper}()},
\code{\link{sdf_rlnorm}()},
\code{\link{sdf_rnorm}()},
\code{\link{sdf_rpois}()},
\code{\link{sdf_rt}()},
\code{\link{sdf_runif}()},
\code{\link{sdf_rweibull}()}
}
\concept{Spark statistical routines}
