% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{sqlf_config}
\alias{sqlf_config}
\title{Write a project-level sqlfluff configuration file}
\usage{
sqlf_config(
  dialect = NULL,
  rules = NULL,
  exclude_rules = NULL,
  max_line_length = NULL,
  glue = NULL,
  path = ".sqlfluff",
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{dialect}{SQL dialect name (e.g. `"ansi"`, `"bigquery"`, `"postgres"`,
`"teradata"`). See [sqlf_dialects()] for available options.}

\item{rules}{Character vector of rule codes to enable.}

\item{exclude_rules}{Character vector of rule codes to exclude.}

\item{max_line_length}{Maximum allowed line length.}

\item{glue}{If `TRUE`, enables [glue::glue_sql()] placeholder handling
by default for all lint, fix, and parse calls.}

\item{path}{File path to write. Defaults to `".sqlfluff"` in the current
working directory.}

\item{overwrite}{If `FALSE` (default), refuses to overwrite an existing
file. Set to `TRUE` to replace it.}

\item{...}{Additional settings as named arguments. These are added to the
`[sqlfluff]` section of the configuration.}
}
\value{
The file path, invisibly.
}
\description{
Writes a `.sqlfluff` configuration file that sqlfluff automatically
discovers. Once written, [sqlf_lint()], [sqlf_fix()], and [sqlf_parse()]
will use these settings without needing explicit arguments.
}
\examples{
path <- tempfile(fileext = ".sqlfluff")
sqlf_config(dialect = "postgres", path = path)
readLines(path)
unlink(path)

}
