% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{sqlf_lint}
\alias{sqlf_lint}
\title{Lint a SQL query}
\usage{
sqlf_lint(
  sql = NULL,
  file = NULL,
  dialect = NULL,
  rules = NULL,
  exclude_rules = NULL,
  config = NULL,
  glue = NULL
)
}
\arguments{
\item{sql}{A SQL string to lint.}

\item{file}{Path to a SQL file to lint.}

\item{dialect}{SQL dialect (e.g. `"ansi"`, `"bigquery"`, `"postgres"`).}

\item{rules}{Character vector of rule codes to check.}

\item{exclude_rules}{Character vector of rule codes to skip.}

\item{config}{A [sqlf_config()] object.}

\item{glue}{If `TRUE`, treat `\{var\}` placeholders as `glue::glue_sql`
variables and use the placeholder templater so linting works correctly.
`NULL` (the default) reads the `glue` setting from the project `.sqlfluff`
config file; `FALSE` explicitly disables glue handling regardless of
project config.}
}
\value{
A data.frame of class `"sqlf_lint_results"` with columns
  `line_no`, `line_pos`, `code`, `description`, and `name`.
  Returns a zero-row data.frame if there are no violations.
}
\description{
Checks a SQL string or file for style and syntax violations using sqlfluff.
}
\examples{
\dontshow{if (reticulate::virtualenv_exists("r-sqlfluffr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sqlf_lint(sql = "SELECT  a,b from t where x=1\n")
sqlf_lint(sql = "SELECT TOP 10 * FROM t\n", dialect = "tsql")
\dontshow{\}) # examplesIf}
}
