% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_period.R
\name{select_period}
\alias{select_period}
\title{Retrieve a list of interaction terms from a sdid model representing the pre-intervention period}
\usage{
select_period(sdid, period = "post", cohorts = NULL)
}
\arguments{
\item{sdid}{A sdid object}

\item{period}{One of 'pre' or 'post', to return the pre-intervention or
post-intervention coefficients respectively}

\item{cohorts}{A character vector containing cohort levels to include in the
term selection. If \code{cohorts} is omitted, all available cohorts will be
selected}
}
\value{
character vector
}
\description{
Retrieve a list of interaction terms from a sdid model representing the pre-intervention period
}
\examples{
# Fit a staggered difference-in-differences model
sdid_hosp <- sdid(hospitalized ~ cohort + yr + age + sex + comorb,
                  df = hosp,
                  intervention_var  = "intervention_yr")

# Select coefficients corresponding to the PRE-intervention period for cohort 5
coef_selection_pre <- select_period(sdid_hosp,
                                period = "pre",
                                cohorts = "5")
coef_selection_pre

# Pass the set of coefficients to `ave_coeff` to aggregate the effect of the
# intervention
ave_coeff(sdid_hosp, coefs = coef_selection_pre)

# Select coefficients corresponding to the POST-intervention period for cohort 5
coef_selection_post <- select_period(sdid_hosp,
                                     period = "post",
                                     cohorts = "5")
coef_selection_post

# Pass the set of coefficients to `ave_coeff` to aggregate the effect of the
# intervention
ave_coeff(sdid_hosp, coefs = coef_selection_post)
}
