% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createAMMI.R
\name{report.AMMI}
\alias{report.AMMI}
\title{Report method for class AMMI}
\usage{
\method{report}{AMMI}(x, ..., outfile = NULL)
}
\arguments{
\item{x}{An object of class AMMI.}

\item{...}{Not used.}

\item{outfile}{A character string, the name and location of the output .pdf
and .tex file for the report. If \code{NULL}, a report with a default name
will be created in the current working directory.}
}
\value{
A pdf and tex report.
}
\description{
A pdf report will be created containing a summary of an AMMI object.
Simultaneously the same report will be created as a tex file.
}
\examples{
## Run AMMI analysis on TDMaize.
geAmmi <- gxeAmmi(TD = TDMaize, trait = "yld")
\donttest{
## Create a pdf report summarizing the results.
report(geAmmi, outfile = tempfile(fileext = ".pdf"))
}

}
\seealso{
Other AMMI: 
\code{\link{fitted.AMMI}()},
\code{\link{gxeAmmi}()},
\code{\link{plot.AMMI}()},
\code{\link{residuals.AMMI}()}
}
\concept{AMMI}
