% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.bayes.spcor}
\alias{ci.bayes.spcor}
\title{Bayesian credible interval for a semipartial correlation with a
skeptical prior}
\usage{
ci.bayes.spcor(alpha, prior_sd, cor, se)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior_sd}{standard deviation of skeptical prior distribution}

\item{cor}{estimated semipartial partial correlation}

\item{se}{standard error of estimated semipartial correlation}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean (Bayesian estimate of correlation)
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes an approximate Bayesian credible interval for a semipartial
correlation with a skeptical prior. The skeptical prior distribution is
Normal with a mean of 0 and a small standard deviation. A skeptical prior
assumes that the population semipartial correlation is within a range of
small values (-r to r). If the skeptic is 95\% confident that the population
correlation is between -r and r, then the prior standard deviation can be
set to r/1.96. A semipartial correlation that is less than .2 in absolute
value is typically considered to be "small", and the prior standard
deviation could then be set to .2/1.96. A semipartial correlation value
that is considered to be small will depend on the application. This function
requires the standard error of the estimated semipartial correlation which
can be obtained from the ci.spcor function.

For more details, see Section 2.36 of Bonett (2021, Volume 2)
}
\examples{
ci.bayes.spcor(.05, .1, .582, .137)

# Should return:
# Posterior mean     LL    UL
#         0.2273 0.0729 0.371


}
\references{
\insertRef{Bonett2021}{statpsych}
}
